## Описание

Датасет S-data содержит информацию о предложениях и аргументативных связях между ними в корпусе "Научные тексты".

При использовании датасета просьба ссылаться на статью:
Сидорова Е.А., Ахмадеева И.Р., Загорулько Ю.А., Кононенко И.С., Серый А.С., Чагина П.М., Шестаков В.К. Комплексный подход к анализу аргументативных отношений в текстах научной коммуникации // Онтология проектирования. 2023. Т. 13, №4(50). С. 562–579. DOI: 10.18287/2223-9537-2023-13-4-562-579.

## Формат данных

texts.csv - данные о всех текстах, содержит следующие столбцы:
- text: id текста на сайте
- content: полный текст
- url: ссылка на текст на сайте
- path: "путь" от корня сайта, включающий названия всех корпусов, в которые входит текст, и название текста

paragraphs.csv - данные о всех абзацах во всех текстах, содержит следующие столбцы:
- id: номер абзаца
- span: границы абзаца
- content: текстовое представление абзаца
- text: id текста на сайте
- url: ссылка на текст на сайте
- path: "путь" от корня сайта, включающий названия всех корпусов, в которые входит текст, и название текста

segments.csv - данные о всех сегментах во всех текстах, содержит следующие столбцы:
- id: номер сегмента внутри текста
- span: границы сегмента
- content: текстовое представление сегмента
- paragraph_id: номер абзаца, в который входит текст
- text: id текста на сайте
- url: ссылка на текст на сайте
- path: "путь" от корня сайта, включающий названия всех корпусов, в которые входит текст, и название текста

data.csv - данные о связях между сегментами, которые включают положительные и отрицательные примеры. Таблица содержит следующие столбцы:
- head_id/dependency_id: номера сегментов (при наличии связи dependency_id является посылкой, head_id - заключением), межу которыми предсказывается наличие аргументативной связи
- label: наличие аргументативной связи, принимает одно из трех значений:
	- none: отсутствие связи (отрицательный пример)
	- support: поддержка (положительный пример)
	- attack: атака (положительный пример)
- weight: количество экспертов, разметивших положительный пример (для отрицательных примеров соответствует весу того положительного примера, на основе которого он был построен)
- text: id текста на сайте
- url: ссылка на текст на сайте
- path: "путь" от корня сайта, включающий названия всех корпусов, в которые входит текст, и название текста

split.json - разбиение текстов на train/val/test. Одно разбиение описывает один эксперимент. Имеет следующий формат:
```json
[{
	"train": ["train_id_1", "train_id_2", ...],
	"val": ["val_id_1", "val_id_2", ...],
	"test": ["test_id_1", "test_id_2", ...]
}]
```